@extends('layouts.admin')

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page">Guia de atendimento</li>
        <li class="breadcrumb-item active" aria-current="page">Buscar servidor</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Buscar servidor
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                @if ($servidores->count() == 0 && $busca != null)
                    <div class="alert alert-danger">
                        <p>Nenhum servidor foi encontrado</p>
                    </div>
                @endif
                <form action="">
                    <div class="form-row">
                        <div class="form-group col-2">
                            <select name="filtro" class="form-control">
                                @foreach ($filtros as $filtro)
                                <option value="{{ $filtro->getIndex() }}" {{ $filtroSelecionado->isEqual($filtro) ? 'selected' : '' }}>{{ $filtro->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="input-group col-5">
                            <input type="text" required autofocus name="busca" maxlength="150" class="form-control @error('busca') is-invalid @enderror" value="{{ $busca }}">
                        </div>
                        <div class="col">
                            <button class="btn btn-primary" type="submit"><i data-feather="search"></i> Buscar</button>

                            @if ($servidores->count() == 0 && $busca != null)
                            <a href="{{ route('admin.servidores.create-simplificado', ['redirectTo' => url('admin/guia-atendimento/atender')]) }}" class="btn btn-primary"><i data-feather="plus"></i> Cadastrar</a>
                            @endif
                        </div>
                    </div>
                </form>

                @if ($servidores->count() > 0)
                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Situação</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($servidores as $servidor)
                        <tr>
                            <td>{{ $servidor->nome }}</td>
                            <td>{{ $servidor->situacao() }}</td>
                            <td>
                                @button([
                                'route' => 'admin.guia-atendimento.create',
                                'routeParams' => ['servidor' => $servidor],
                                'class' => 'btn-primary',
                                'label' => 'Atender',
                                'icon' => 'clipboard'
                                ])
                                @endbutton
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $servidores->links() }}
                @endif
            </section>
        </div>
    </div>
</div>
@endsection
