@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/geracao-carteirinha-index.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Geração de carteirinha</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Geração de carteirinha
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                <form action="{{ route('admin.geracao-carteirinha.gera') }}" id="form-gerar" method="post" target="new">
                    @csrf
                    <div class="form-row">
                        <div class="btn-group btn-group-toggle col-2" data-toggle="buttons">
                            <label class="btn btn-outline-secondary active">
                                <input name="via" value="1" type="radio" checked> 1ª via
                            </label>
                            <label class="btn btn-outline-secondary">
                                <input name="via" value="2" type="radio"> 2ª via
                            </label>
                        </div>
                        <div class="btn-group btn-group-toggle mx-2 col-3" data-toggle="buttons">
                            <label class="btn btn-outline-secondary active">
                                <input id="radio-todos" name="selecao" value="todos" type="radio" checked> Todos
                            </label>
                            <label class="btn btn-outline-secondary">
                                <input id="radio-selecionar" name="selecao" value="selecionar" type="radio"> Selecionar
                            </label>
                        </div>
                        <div id="div-busca-servidores" class="col-7 row">
                            <select name="filtro" form="busca-servidores" class="form-control col-4" id="select-filtro">
                                @foreach ($filtrosServidores as $filtro)
                                <option value="{{ $filtro->getIndex() }}" @if (optional($filtroSelecionado)->isEqual($filtro)) selected @endif>{{ $filtro->getValue() }}</option>
                                @endforeach
                            </select>
                            <div class="input-group col-8">
                                <input type="text" form="busca-servidores" id="text-busca" autocomplete="off" value="{{ $busca ?? '' }}" name="busca" class="form-control busca @error('busca') is-invalid @enderror">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-outline-secondary" form="busca-servidores" title="Buscar"><i data-feather="search"></i></button>
                                    <a href="{{ route('admin.geracao-carteirinha.index') }}" class="btn btn-outline-secondary" title="Limpar"><i data-feather="x"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="form-row">
                        @button([
                        'icon' => '',
                        'label' => 'Gerar',
                        'class' => 'btn-primary'
                        ])
                        @endbutton
                    </div>
                </form>
                <form id="busca-servidores" action="">
                </form>
            </section>

            @if ($servidores)
            <section class="hk-sec-wrapper" id="section-servidores">
                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th class="w-25">
                                <input type="checkbox" id="check-selecionar-todos" title="Selecionar todos">
                            </th>
                            <th>Nome</th>
                            <th>Registro(s) ativo(s)</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($servidores as $servidor)
                        <tr>
                            <td><input type="checkbox" form="form-gerar" name="servidores[]" class="check-servidor" value="{{ $servidor->id }}"></td>
                            <td>{{ $servidor->nome_exibir }}</td>
                            <td>{{ implode(', ', $servidor->registros()->ativos()->get()->pluck('numero')->toArray()) }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </section>
            @endif
        </div>
    </div>
</div>
<div class="modal fade" id="modal-selecione-servidores" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <p>Selecione os servidores para gerar a carteirinha, ou clique em "Todos os servidores"</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Sim</button>
            </div>
        </div>
    </div>
</div>
@endsection
