@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
<script src="{{ asset('js/admin/funcionarios/create-edit.js') }}"></script>
<script src="{{ asset('js/admin/telefones.js') }}"></script>
<script src="{{ asset('js/admin/emails.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.funcionarios.index') }}">Funcionários</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ $funcionario->nome }}</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Editar funcionário
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.funcionarios.update', ['funcionario' => $funcionario]) }}" method="post">
                    @csrf
                    @method('PUT')

                    @alerts
                    @endalerts

                    <input type="hidden" id="hidden-sucesso" value="{{ session('sucesso') }}">

                    <div class="form-row">
                        <div class="form-group col-6">
                            <label for="nome">Nome *</label>
                            <input type="text" required autofocus name="nome" maxlength="150" class="form-control @error('nome') is-invalid @enderror" value="{{ old('nome') ?? $funcionario->nome }}">
                        </div>
                        <div class="form-group col-6">
                            <label for="funcao">Função *</label>
                            <input type="text" required name="funcao" maxlength="50" class="form-control @error('funcao') is-invalid @enderror" value="{{ old('funcao') ?? $funcionario->funcao }}">
                        </div>
                        <div class="form-group col-3">
                            <label for="sexo">Sexo *</label>
                            <select name="sexo" class="form-control @error('sexo') is-invalid @enderror" required>
                                @foreach ($sexos as $sexo)
                                <option value="{{ $sexo->getIndex() }}" {{ $funcionario->sexo && $funcionario->sexo->isEqual($sexo) ? 'selected' : '' }}>{{ $sexo->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label for="data_nascimento">Data de nascimento *</label>
                            <input type="text" required name="data_nascimento" class="data form-control data_nascimento @error('data_nascimento') is-invalid @enderror" value="{{ old('data_nascimento') ?? $funcionario->data_nascimento->format('d/m/Y') }}">
                        </div>
                        <div class="form-group col-3">
                            <label for="cpf">CPF *</label>
                            <input type="text" required name="cpf" class="form-control cpf @error('cpf') is-invalid @enderror" value="{{ old('cpf') ?? $funcionario->cpf }}">
                        </div>
                        <div class="form-group col-3">
                            <label for="rg">RG *</label>
                            <input type="text" required name="rg" maxlength="10" class="form-control rg @error('rg') is-invalid @enderror" value="{{ old('rg') ?? $funcionario->rg }}">
                        </div>
                        <div class="form-group col-3">
                            <label for="cnh">CNH</label>
                            <input type="text" name="cnh" maxlength="10" class="form-control cnh @error('cnh') is-invalid @enderror" value="{{ old('cnh') ?? $funcionario->cnh }}">
                        </div>
                        @include('components.endereco', ['endereco' => $funcionario->endereco ?? null])
                        @include('components.telefones', ['telefones' => $funcionario->contatos()->telefones()->get(), 'malaDireta' => true, 'container' => 'form-row col-12'])

                        @include('components.email', ['name' => 'email[0]', 'obrigatorio' => false, 'valor' => old('email.0.endereco', optional($funcionario->contatos()->emails()->first())->valor)])

                        <div class="form-group col-12">
                            <label for="observacoes">Observações</label>
                            <textarea name="observacoes" class="form-control @error('observacoes') is-invalid @enderror">{{ old('observacoes') ?? $funcionario->observacoes }}</textarea>
                        </div>
                    </div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    <button id="btn-incluir-fixo" type="button" class="btn btn-secondary"><i data-feather="plus"></i> Telefone fixo</button>
                    <button id="btn-incluir-celular" type="button" class="btn btn-secondary"><i data-feather="plus"></i> Telefone celular</button>
                    @button([
                    'route' => 'admin.funcionarios.dependentes.index',
                    'routeParams' => ['funcionario' => $funcionario],
                    'icon' => 'users',
                    'label' => 'Dependentes',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.funcionarios.convenios.index',
                    'routeParams' => ['funcionario' => $funcionario],
                    'icon' => 'list',
                    'label' => 'Convênios',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                    @button([
                    'icon' => 'file-text',
                    'label' => 'Processos',
                    'class' => 'btn-secondary',
                    'route' => 'admin.processos-juridicos.index',
                    'routeParams' => ['pessoa' => $funcionario->id, 'tipo' => 'funcionario']
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.funcionarios.index',
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
<div class="modal" id="modal-pergunta" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5>{{ session('status') }}</h5>
            </div>
            <div class="modal-body">
                <p>Deseja continuar e editar o funcionário ou voltar para página anterior?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Continuar e editar</button>
                <a href="{{ route('admin.funcionarios.index') }}" class="btn btn-secondary">Voltar</a>
            </div>
        </div>
    </div>
</div>
@endsection