@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.funcionarios.index') }}">Funcionários</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.funcionarios.edit', ['funcionario' => $funcionario]) }}">{{ $funcionario->nome }}</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.funcionarios.dependentes.index', ['funcionario' => $funcionario]) }}">Dependentes</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.funcionarios.dependentes.edit', ['funcionario' => $funcionario, 'dependente' => $dependente]) }}">{{ $dependente->nome }}</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.funcionarios.dependentes.convenios.index', ['funcionario' => $funcionario, 'dependente' => $dependente]) }}">Convênios</a></li>
        <li class="breadcrumb-item active" aria-current="page">Editar</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Editar convênio
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.funcionarios.dependentes.convenios.update', ['funcionario' => $funcionario, 'dependente' => $dependente, 'convenio' => $convenio]) }}" method="post">
                    @csrf
                    @method('PUT')

                    @alerts
                    @endalerts

                    <div class="form-row">
                        <div class="form-group col-4">
                            <label for="convenio_id">Convênio *</label>
                            <select name="convenio_id" required id="select-convenio" class="form-control convenio @error('convenio') is-invalid @enderror">
                                @foreach ($convenios as $c)
                                <option value="{{ $c->id }}" {{ old('convenio_id') ?? $c->id == $convenio->convenio->id ? 'selected' : '' }}>{{ $c->nome }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.funcionarios.dependentes.convenios.index',
                    'routeParams' => ['funcionario' => $funcionario, 'dependente' => $dependente],
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection