@extends('layouts.admin')

@push('js')
<script src='{{ asset("vendors/fullcalendar/locales/pt-br.js") }}'></script>
<script src='{{ asset("vendors/fullcalendar/core.min.js") }}'></script>
<script src='{{ asset("vendors/fullcalendar/daygrid.min.js") }}'></script>
<script src="{{ asset('js/admin/feriados/index.js') }}"></script>
@endpush

@push('css')
<link href='{{ asset("vendors/fullcalendar/core.min.css") }}' rel='stylesheet' />
<link href='{{ asset("vendors/fullcalendar/daygrid.min.css") }}' rel='stylesheet' />
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Feriados</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Feriados
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                @button([
                'route' => 'admin.feriados.create',
                'icon' => 'plus',
                'label' => 'Incluir',
                'class' => 'btn-primary'
                ])
                @endbutton

                <input type="hidden" id="hidden-event-source-url" value="{{ route('admin.feriados.load') }}">
                <div class="mt-3" id="calendario"></div>
            </section>
        </div>
    </div>
</div>
@endsection