@extends('layouts.admin')

@push('css')
<link href="{{ asset('vendors/select2/dist/css/select2.min.css') }}" rel="stylesheet" type="text/css">
@endpush

@push('js')
<script src="{{ asset('vendors/select2/dist/js/select2.full.min.js') }}"></script>
<script src="{{ asset('js/admin/envio-sms/selecao-contatos.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.envio-sms.mensagens-enviadas') }}">Envio de SMS</a></li>
        <li class="breadcrumb-item active" aria-current="page">Seleção de contatos</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Selecione os contatos
        </h4>
    </div>
    <!-- /Title -->

    <div class="col-xl-12">
        <section class="hk-sec-wrapper">
            @alerts
            @endalerts

            <input type="hidden" id="hidden-filtro" value="{{ $filtro }}">

            <form id="filtro"></form>

            <form id="form-seleciona-contatos" method="POST" action="{{ route('admin.envio-sms.armazena-contatos') }}">
                @csrf
                <div class="row">
                    <div class="col-2">
                        @button([
                        'icon' => 'arrow-right',
                        'label' => 'Avançar',
                        'class' => 'btn-primary',
                        ])
                        @endbutton
                    </div>
                    <div class="col">
                        <div class="form-inline float-right mx-2">
                            <button class="btn btn-outline-primary" type="submit" form="filtro">Filtrar</button>
                            <a href="{{ route('admin.envio-sms.selecao-contatos-form') }}" class="btn btn-outline-secondary mx-1" form="filtro">Limpar</a>
                        </div>
                        <div class="float-right col-4">
                            <div id="div-secretaria">
                                <select name="secretaria" id="select-secretaria" class="form-control" form="filtro">
                                    @foreach ($secretarias as $secretaria)
                                    <option value="{{ $secretaria->id }}">{{ $secretaria->nome }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div id="div-cargo">
                                <select name="cargo" id="select-cargo" class="form-control" form="filtro">
                                    @foreach ($cargos as $cargo)
                                    <option value="{{ $cargo->id }}">{{ $cargo->nome }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="btn-group btn-group-toggle float-right" data-toggle="buttons">
                            @foreach ($filtros as $filtro)
                            @php
                            $enabled = $filtro->isEqual($filtroServidor);
                            $checked = $enabled ? 'checked' : '';
                            $active = $enabled ? 'active' : '';
                            @endphp
                            <label class="btn btn-outline-secondary {{ $active }}">
                                <input class="filtro-servidor" form="filtro" name="filtro_servidor" value="{{ $filtro->getValue() }}" type="radio" {{ $checked }}> {{ $filtro }}
                            </label>
                            @endforeach
                        </div>
                    </div>

                </div>
                <div class="row">
                    <table class="table mt-3">
                        <thead>
                            <tr>
                                <th><input title="Selecionar todos" type="checkbox" id="check-selecionar-todos"></th>
                                <th>Nome</th>
                                <th>Cargo</th>
                                <th>Unidade</th>
                                <th>Celular</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($contatos as $contato)
                            <tr>
                                <td>
                                    <input type="checkbox" class="check-contato" name="contatos[]" value="{{ $contato->id }}">
                                </td>
                                <td><a target="blank" href="{{ route('admin.servidores.edit', ['servidor' => $contato]) }}">{{ $contato->nome_exibir }}</a></td>
                                <td>{{ implode(',', $contato->registros()->ativos()->get()->pluck('cargo')->pluck('nome')->toArray()) }}</td>
                                <td>{{ implode(',', $contato->registros()->ativos()->get()->pluck('unidadeOrganizacional')->pluck('sigla')->toArray()) }}</td>
                                <td>{{ $contato->celularMalaDireta()->getNumeroFormatado() }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </form>
        </section>
    </div>
</div>
<div class="modal" id="modal-selecione-contatos" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <p>Selecione pelo menos um contato como destinatário</p>
            </div>
            <div class="mensagem-erro"></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">OK</button>
            </div>
        </div>
    </div>
</div>
@endsection