@extends('layouts.admin')

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.envio-sms.mensagens-enviadas') }}">Envio de SMS</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.envio-sms.selecao-contatos-form') }}">Seleção de contatos</a></li>
        <li class="breadcrumb-item" aria-current="page">Escrever mensagem</li>
        <li class="breadcrumb-item active" aria-current="page">Revisar e enviar</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Revisar e enviar mensagem
        </h4>
    </div>
    <!-- /Title -->

    <div class="col-xl-12">
        <section class="hk-sec-wrapper">
            <div class="form-row">
                <div class="form-group col-12">
                    <label for="mensagem">Mensagem</label>
                    <textarea type="text" readonly name="mensagem" class="form-control-plaintext">{{ $mensagem }}</textarea>
                </div>
            </div>
        </section>
        <section class="hk-sec-wrapper">
            <h5 class="hk-sec-title">Contatos</h5>

            <table class="table mt-3">
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>Telefone</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($contatos as $contato)
                    <tr>
                        </td>
                        <td>{{ $contato->nome_exibir }}</td>
                        <td>{{ $contato->celularMalaDireta()->getNumeroFormatado() }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            <hr>
            <form action="{{ route('admin.envio-sms.envia') }}" method="POST">
                @csrf
                @button([
                'icon' => 'send',
                'label' => 'Enviar',
                'class' => 'btn-primary'
                ])
                @endbutton
                @button([
                'route' => 'admin.envio-sms.escrever-mensagem-form',
                'icon' => 'arrow-left',
                'label' => 'Voltar',
                'class' => 'btn-secondary'
                ])
                @endbutton
            </form>
        </section>
    </div>
</div>
@endsection