@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/dependentes/index.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route($routes['dependido']['index']['route']) }}">{{ $dependido }}</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route($routes['dependido']['edit']['route'], $routes['dependido']['edit']['params']) }}">{{ $routes['dependido']['nome'] }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">Dependentes</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Dependentes
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                @button([
                'route' => $routes['dependente']['create']['route'],
                'routeParams' => $routes['dependente']['create']['params'],
                'icon' => 'plus',
                'label' => 'Incluir',
                'class' => 'btn-primary'
                ])
                @endbutton

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Data de nascimento</th>
                            <th>Grau</th>
                            <th>Especial</th>
                            <th>Convênios</th>
                            <th>Ativo</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($dependentes as $dependente)
                        @php
                        $listaConvenios = implode(', ', $dependente->convenios->pluck('convenio.nome')->toArray());
                        @endphp
                        <tr>
                            <td>{{ $dependente->nome }}</td>
                            <td>{{ $dependente->data_nascimento->format('d/m/Y') }}</td>
                            <td>{{ $dependente->grau_parentesco->getValue() }}</td>
                            <td>{{ $dependente->especial ? 'SIM' : 'NÃO' }}</td>
                            <td>{{ $listaConvenios }}</td>
                            <td>{{ $dependente->ativo ? 'SIM' : 'NÃO' }}</td>
                            <td>
                                @button([
                                'route' => $routes['dependente']['edit']['route'],
                                'routeParams' => [$routes['dependido']['key'] => $routes['dependente']['edit']['params'][$routes['dependido']['key']], 'dependente' => $dependente],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ])
                                @endbutton
                                @button([
                                'class' => 'btn-danger btn-excluir-dependente',
                                'icon' => 'x',
                                'label' => 'Excluir',
                                'route' => $routes['dependente']['destroy']['route'],
                                'routeParams' => [$routes['dependido']['key'] => $routes['dependente']['destroy']['params'][$routes['dependido']['key']], 'dependente' => $dependente],
                                ])
                                @endbutton
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-dependente" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-dependente">
        @csrf
        @method('DELETE')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o dependente?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection
