@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
<script src="{{ asset('js/admin/dependentes/create-edit.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route($routes['dependido']['index']['route']) }}">{{ $dependido }}</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route($routes['dependido']['edit']['route'], $routes['dependido']['edit']['params']) }}">{{ $routes['dependido']['nome'] }}</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route($routes['dependente']['index']['route'], $routes['dependente']['index']['params']) }}">Dependentes</a></li>
        <li class="breadcrumb-item active" aria-current="page">Incluir</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Incluir dependente
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route($routes['dependente']['store']['route'], $routes['dependente']['store']['params']) }}" method="post">
                    @csrf
                    @alerts
                    @endalerts

                    <div class="form-row">
                        <div class="form-group col-6">
                            <label for="nome">Nome *</label>
                            <input type="text" required autofocus name="nome" maxlength="150" class="form-control @error('nome') is-invalid @enderror" value="{{ old('nome') }}">
                        </div>
                        <div class="form-group col-3">
                            <label for="grau_parentesco">Grau de parentesco *</label>
                            <select name="grau_parentesco" required class="form-control @error('grau_parentesco') is-invalid @enderror">
                                @foreach ($graus as $grau)
                                <option value="{{ $grau->getIndex() }}">{{ $grau->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label for="data_nascimento">Data de nascimento *</label>
                            <input type="text" required name="data_nascimento" class="data form-control @error('data_nascimento') is-invalid @enderror" value="{{ old('data_nascimento') }}">
                        </div>
                        <div class="form-group col-3">
                            <label for="sexo">Sexo *</label>
                            <select name="sexo" required class="form-control @error('sexo') is-invalid @enderror">
                                @foreach ($sexos as $sexo)
                                <option value="{{ $sexo->getIndex() }}">{{ $sexo->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label for="data_admissao">Data de admissão *</label>
                            <input type="text" required name="data_admissao" class="data form-control @error('data_admissao') is-invalid @enderror" value="{{ old('data_admissao') }}">
                        </div>
                        <div class="form-group col-2">
                            <label for="ativo">Ativo *</label>
                            <select name="ativo" required class="form-control @error('ativo') is-invalid @enderror">
                                <option value="1">SIM</option>
                                <option value="0">NÃO</option>
                            </select>
                        </div>
                        <div class="form-group col-2">
                            <label for="especial">Especial *</label>
                            <select name="especial" required class="form-control @error('especial') is-invalid @enderror">
                                <option value="0" selected>NÃO</option>
                                <option value="1">SIM</option>
                            </select>
                        </div>
                        <div class="form-group col-2">
                            <label for="falecido">Falecido *</label>
                            <select name="falecido" required class="form-control @error('falecido') is-invalid @enderror">
                                <option value="0" selected>NÃO</option>
                                <option value="1">SIM</option>
                            </select>
                        </div>
                        <div class="form-group col-12">
                            <label for="observacoes">Observações</label>
                            <textarea type="text" name="observacoes" maxlength="1000" rows="5" class="form-control @error('observacoes') is-invalid @enderror">{{ old('observacoes') }}</textarea>
                        </div>
                    </div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @button([
                    'route' => $routes['dependente']['index']['route'],
                    'routeParams' => $routes['dependente']['index']['params'],
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
<div class="modal" id="modal-pergunta" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5>{{ session('status') }}</h5>
            </div>
            <div class="modal-body">
                <p>Deseja continuar e editar o dependente ou voltar para página anterior?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Continuar e editar</button>
                <a href="{{ route($routes['dependente']['index']['route'], $routes['dependente']['index']['params']) }}" class="btn btn-secondary">Voltar</a>
            </div>
        </div>
    </div>
</div>
@endsection