@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/convenios.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Convênios</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Convênios
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                @button([
                'route' => 'admin.convenios.create',
                'icon' => 'plus',
                'label' => 'Incluir',
                'class' => 'btn-primary'
                ])
                @endbutton

                @busca([
                'route' => 'admin.convenios.index',
                'busca' => $termo ?? null
                ])
                @endbusca

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Telefone</th>
                            <th>Especialidade</th>
                            <th>Tipo</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($convenios as $convenio)
                        <tr>
                            <td>{{ $convenio->nome }}</td>
                            <td>{{ implode(' ', $convenio->contatos()->telefones()->take(2)->get()->pluck('valor')->toArray()) }}</td>
                            <td>{{ $convenio->especialidade->nome }}</td>
                            <td>{{ $convenio->tipo }}</td>
                            <td>
                                @button([
                                'route' => 'admin.convenios.edit',
                                'routeParams' => ['convenio' => $convenio],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ])
                                @endbutton
                                @button([
                                'class' => 'btn-danger btn-excluir',
                                'icon' => 'x',
                                'label' => 'Excluir',
                                'route' => 'admin.convenios.destroy',
                                'routeParams' => ['convenio' => $convenio],
                                ])
                                @endbutton
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $convenios->links() }}
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir">
        @csrf
        @method('DELETE')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o convênio?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection