@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
<script src="{{ asset('js/admin/convenios/create-edit.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.convenios.index') }}">Convênios</a></li>
        <li class="breadcrumb-item active" aria-current="page">Editar</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Editar convênio
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.convenios.update', ['convenio' => $convenio]) }}" method="post">
                    @csrf
                    @method('PUT')
                    @alerts
                    @endalerts

                    <div class="form-row">
                        <div class="form-group col-6">
                            <label for="nome">Nome *</label>
                            <input type="text" required autofocus name="nome" maxlength="50" class="form-control @error('nome') is-invalid @enderror" value="{{ old('nome') ?? $convenio->nome }}">
                        </div>
                        <div class="form-group col-3">
                            <label for="cpf">CPF</label>
                            <input type="text" name="cpf" class="cpf form-control @error('cpf') is-invalid @enderror" value="{{ old('cpf') ?? $convenio->cpf }}">
                        </div>
                        <div class="form-group col-3">
                            <label for="cnpj">CNPJ</label>
                            <input type="text" name="cnpj" class="cnpj form-control @error('cnpj') is-invalid @enderror" value="{{ old('cnpj') ?? $convenio->cnpj }}">
                        </div>
                        <div class="form-group col-2">
                            <label for="validade">Validade</label>
                            <input type="text" name="validade" class="data form-control @error('validade') is-invalid @enderror" value="{{ old('validade') ?? $convenio->validade->format('d/m/Y') }}">
                        </div>
                        <div class="form-group col-2">
                            <label for="desconto">Desconto</label>
                            <select name="desconto" class="form-control @error('desconto') is-invalid @enderror">
                                <option value="0" {{ ! $convenio->desconto ? 'selected' : '' }}>NÃO</option>
                                <option value="1" {{   $convenio->desconto ? 'selected' : '' }}>SIM</option>
                            </select>
                        </div>
                        <div class="form-group col-2">
                            <label for="especialidade_id">Especialidade</label>
                            <select name="especialidade_id" class="form-control @error('especialidade_id') is-invalid @enderror">
                                @foreach ($especialidades as $especialidade)
                                <option value="{{ $especialidade->id }}" {{ $convenio->especialidade_id == $especialidade->id }}>{{ $especialidade->nome }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-2">
                            <label for="tipo">Tipo</label>
                            <select name="tipo" class="form-control @error('tipo') is-invalid @enderror">
                                @foreach ($tipos as $tipo)
                                <option value="{{ $tipo->getIndex() }}" {{ optional($convenio->tipo)->isEqual($tipo) ? 'selected' : '' }}>{{ $tipo }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-4">
                            <label for="tipo_beneficiario">Tipo beneficiário</label>
                            <select name="tipo_beneficiario" class="form-control @error('tipo_beneficiario') is-invalid @enderror">
                                @foreach ($tiposBeneficiarios as $tipo)
                                <option value="{{ $tipo->getIndex() }}" @if (optional($convenio->tipo_beneficiario)->isEqual($tipo)) selected @endif>{{ $tipo }}</option>
                                @endforeach
                            </select>
                        </div>
                        @include('components.endereco', ['endereco' => $convenio->endereco ?? null])
                        @include('components.telefones', ['telefones' => $convenio->contatos()->telefones()->get(), 'malaDireta' => false, 'container' => 'form-row col-12'])
                        <div class="form-group col-12">
                            <label for="observacoes">Observações</label>
                            <textarea name="observacoes" class="form-control @error('observacoes') is-invalid @enderror">{{ old('observacoes') ?? $convenio->observacoes }}</textarea>
                        </div>
                    </div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    <button id="btn-incluir-fixo" type="button" class="btn btn-secondary"><i data-feather="plus"></i> Telefone fixo</button>
                    <button id="btn-incluir-celular" type="button" class="btn btn-secondary"><i data-feather="plus"></i> Telefone celular</button>
                    @button([
                    'route' => 'admin.convenios.index',
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection