@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
<script src="{{ asset('js/admin/convenios/create-edit.js') }}"></script>
<script src="{{ asset('js/admin/telefones.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.convenios.index') }}">Convênios</a></li>
        <li class="breadcrumb-item active" aria-current="page">Incluir</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Incluir convênio
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.convenios.store') }}" method="post">
                    @csrf
                    @alerts
                    @endalerts

                    <div class="form-row">
                        <div class="form-group col-6">
                            <label for="nome">Nome *</label>
                            <input type="text" required autofocus name="nome" maxlength="50" class="form-control @error('nome') is-invalid @enderror" value="{{ old('nome') }}">
                        </div>
                        <div class="form-group col-3">
                            <label for="cpf">CPF</label>
                            <input type="text" name="cpf" class="cpf form-control @error('cpf') is-invalid @enderror" value="{{ old('cpf') }}">
                        </div>
                        <div class="form-group col-3">
                            <label for="cnpj">CNPJ</label>
                            <input type="text" name="cnpj" class="cnpj form-control @error('cnpj') is-invalid @enderror" value="{{ old('cnpj') }}">
                        </div>
                        <div class="form-group col-2">
                            <label for="validade">Validade</label>
                            <input type="text" name="validade" class="data form-control @error('validade') is-invalid @enderror" value="{{ old('validade') }}">
                        </div>
                        <div class="form-group col-2">
                            <label for="desconto">Desconto</label>
                            <select name="desconto" class="form-control @error('desconto') is-invalid @enderror">
                                <option value="0">NÃO</option>
                                <option value="1">SIM</option>
                            </select>
                        </div>
                        <div class="form-group col-2">
                            <label for="especialidade_id">Especialidade</label>
                            <select name="especialidade_id" class="form-control @error('especialidade_id') is-invalid @enderror">
                                @foreach ($especialidades as $especialidade)
                                <option value="{{ $especialidade->id }}">{{ $especialidade->nome }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-2">
                            <label for="tipo">Tipo</label>
                            <select name="tipo" class="form-control @error('tipo') is-invalid @enderror">
                                @foreach ($tipos as $tipo)
                                <option value="{{ $tipo->getIndex() }}">{{ $tipo }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-4">
                            <label for="tipo_beneficiario">Tipo beneficiário</label>
                            <select name="tipo_beneficiario" class="form-control @error('tipo_beneficiario') is-invalid @enderror">
                                @foreach ($tiposBeneficiarios as $tipo)
                                <option value="{{ $tipo->getIndex() }}">{{ $tipo }}</option>
                                @endforeach
                            </select>
                        </div>
                        @include('components.endereco')

                        @include('components.telefone', ['name' => 'telefone[0]', 'obrigatorio' => true, 'valor' => old('telefone.0.numero')])
                        @include('components.telefone', ['name' => 'telefone[1]', 'tipoTelefone' => 'celular', 'valor' => old('telefone.1.numero')])
                        <div class="form-group col-12">
                            <label for="observacoes">Observações</label>
                            <textarea name="observacoes" class="form-control @error('observacoes') is-invalid @enderror">{{ old('observacoes') }}</textarea>
                        </div>
                    </div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.convenios.index',
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection