@extends('layouts.admin')

@push('css')
<link href="{{ asset('vendors/daterangepicker/daterangepicker.css') }}" rel="stylesheet" type="text/css">
@endpush

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
<script src="{{ asset('vendors/moment/min/moment-with-locales.min.js') }}"></script>
<script src="{{ asset('vendors/daterangepicker/daterangepicker.js') }}"></script>
<script src="{{ asset('js/admin/contas-pagar-receber/create-edit-pagar.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.contas-pagar-receber.index') }}">Contas a pagar e receber</a></li>
        <li class="breadcrumb-item active" aria-current="page">Incluir saída</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Incluir saída
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.contas-pagar.store') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    @alerts
                    @endalerts

                    <input type="hidden" id="url-api-classificacoes" value="{{ url('api/plano-contas') }}">
                    <input type="hidden" id="hidden-classificacao-selecionada" value="{{ old('classificacao_conta_id') }}">

                    <div class="form-row">
                        <div class="form-group col-4">
                            <label for="descricao">Descrição *</label>
                            <input required autofocus type="text" name="descricao" maxlength="255" class="form-control @error('descricao') is-invalid @enderror" value="{{ old('descricao') }}">
                        </div>
                        <div class="form-group col-5">
                            <label for="numero_documento">Número documento</label>
                            <input type="text" name="numero_documento" maxlength="255" class="form-control @error('numero_documento') is-invalid @enderror" value="{{ old('numero_documento') }}">
                        </div>
                        <div class="form-group col-3">
                            <label for="nota_fiscal">Nota fiscal</label>
                            <input type="text" name="nota_fiscal" maxlength="100" class="form-control @error('nota_fiscal') is-invalid @enderror" value="{{ old('nota_fiscal') }}">
                        </div>
                        <div class="form-group col-2">
                            <label for="vencimento">Data *</label>
                            <input type="text" name="vencimento" maxlength="10" class="form-control data @error('vencimento') is-invalid @enderror" value="{{ old('vencimento', today()->format('d/m/Y')) }}">
                        </div>
                        <div class="form-group col-2">
                            <label for="valor">Valor *</label>
                            <input type="text" id="text-valor" name="valor" maxlength="10" class="form-control dinheiro @error('valor') is-invalid @enderror" value="{{ old('valor') }}">
                        </div>
                        <div class="form-group col-2">
                            <label for="status">Status *</label>
                            <select id="select-status" name="status" class="form-control @error('valor') is-invalid @enderror">
                                @foreach ($statuses as $status)
                                <option value="{{ $status->getIndex() }}" @if (old('status')==$status->getIndex()) selected @endif>{{ $status->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-2" id="div-data-pagamento">
                            <label for="data_pagamento">Data pagamento</label>
                            <input type="text" name="data_pagamento" maxlength="10" class="form-control data @error('data_pagamento') is-invalid @enderror" value="{{ old('data_pagamento') }}">
                        </div>
                        <div class="form-group col-2" id="div-valor-pago">
                            <label for="valor_pago">Valor pago</label>
                            <input type="text" id="text-valor-pago" name="valor_pago" maxlength="10" class="form-control dinheiro @error('valor_pago') is-invalid @enderror" value="{{ old('valor_pago') }}">
                        </div>
                        <div class="form-group col-2" id="div-forma-pagamento">
                            <label for="forma_pagamento">Forma Pagamento</label>
                            <select name="forma_pagamento" class="form-control @error('forma_pagamento') is-invalid @enderror">
                                <option value="" @if (old('forma_pagamento')==null) selected @endif></option>
                                @foreach ($formasPagamento as $formaPagamento)
                                <option value="{{ $formaPagamento->getIndex() }}" @if (old('forma_pagamento')==$formaPagamento->getIndex()) selected @endif>{{ $formaPagamento->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-2">
                            <label for="tipo_despesa">Tipo despesa *</label>
                            <select name="tipo_despesa" id="select-tipo-despesa" class="form-control @error('valor') is-invalid @enderror">
                                @foreach ($tiposDespesa as $tipoDespesa)
                                <option value="{{ $tipoDespesa->getIndex() }}" @if (old('tipo_despesa')==$tipoDespesa->getIndex()) selected @endif>{{ $tipoDespesa->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-4" id="div-responsavel-despesa">
                            <label for="responsavel_despesa">Responsável despesa *</label>
                            <input type="text" name="responsavel_despesa" maxlength="100" class="form-control @error('responsavel_despesa') is-invalid @enderror" value="{{ old('responsavel_despesa') }}">
                        </div>
                        <div class="form-group col-2">
                            <label for="recorrencia">Recorrência *</label>
                            <select name="recorrencia" class="form-control @error('valor') is-invalid @enderror">
                                <option value="" @if (! old('recorrencia')) selected @endif>Não recorrente</option>
                                @foreach ($recorrencias as $recorrencia)
                                <option value="{{ $recorrencia->getIndex() }}" @if (old('recorrencia')==$recorrencia->getIndex()) selected @endif>{{ $recorrencia->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label for="plano_contas_id">Plano de contas</label>
                            <select required name="plano_contas_id" id="select-plano-contas" class="form-control @error('valor') is-invalid @enderror">
                                @foreach ($planosContas as $plano)
                                <option value="{{ $plano->id }}" @if (old('plano_contas_id')==$plano->id) selected @endif>{{ $plano->nome }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label for="classificacao_conta_id">Classificação</label>
                            <select required id="select-classificacao-contas-id" name="classificacao_conta_id" class="form-control @error('valor') is-invalid @enderror">
                            </select>
                        </div>
                        <div class="form-group col-4">
                            <label for="caminho_documento">Documento digitalizado</label>
                            <input type="file" name="caminho_documento" class="@error('caminho_documento') is-invalid @enderror" value="{{ old('caminho_documento') }}">
                        </div>
                        <div class="form-group col-12">
                            <label for="observacoes">Observações</label>
                            <textarea maxlength="255" class="form-control" name="observacoes" rows="3">{{ old('observacoes') }}</textarea>
                        </div>
                    </div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.contas-pagar-receber.index',
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection
