@extends('layouts.admin')

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.cargos.index') }}">Cargos</a></li>
        <li class="breadcrumb-item active" aria-current="page">Incluir</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Incluir cargo
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.cargos.store') }}" method="post">
                    @csrf
                    @alerts
                    @endalerts

                    <div class="form-row">
                        <div class="form-group col-7">
                            <label for="nome">Nome *</label>
                            <input type="text" autofocus name="nome" maxlength="150" class="form-control @error('nome') is-invalid @enderror" value="{{ old('nome') }}">
                        </div>
                        <div class="form-group col-2">
                            <label for="nivel_salarial_id">Nivel *</label>
                            <select name="nivel_salarial_id" class="form-control" required>
                                @foreach ($niveis as $nivel) {
                                <option value="{{ $nivel->id }}" @if (old('nivel_salarial_id') == $nivel->id) selected @endif>{{ $nivel->nome }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.cargos.index',
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection