@extends('layouts.admin')

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page">Logs de Auditoria</li>
        <li class="breadcrumb-item active" aria-current="page">Detalhes</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Detalhes log
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <div class="form-row">
                    <div class="form-group col-4">
                        <label for="tipo">Tipo</label>
                        <input type="text" name="tipo" class="form-control-plaintext" value="{{ $log->auditable_type_readable }}">
                    </div>
                    <div class="form-group col-2">
                        <label for="evento">Evento</label>
                        <input type="text" name="evento" class="form-control-plaintext" value="{{ Str::ucfirst($log->event_readable) }}">
                    </div>
                    <div class="form-group col-4">
                        <label for="usuario">Usuário</label>
                        <input type="text" name="usuario" class="form-control-plaintext" value="{{ $log->user->name }}">
                    </div>
                    <div class="form-group col-2">
                        <label for="data">Data/hora</label>
                        <input type="text" name="data" class="form-control-plaintext" value="{{ $log->created_at->format('d/m/Y H:i:s') }}">
                    </div>
                    <div class="form-group col-4">
                        <label for="ip">Endereço IP</label>
                        <input type="text" name="ip" class="form-control-plaintext" value="{{ $log->ip_address }}">
                    </div>
                    <hr class="col-12">
                    @if ($log->old_values)
                    <div class="form-group col-6">
                        <label for="antes">
                            @if ($log->new_values)
                            Antes da edição
                            @else
                            {{ $log->auditable_type_readable }} {{ $log->event_readable }}
                            @endif
                        </label>
                        <div class="text-dark">
                            @foreach ($log->old_values as $key => $value)
                            <p>{{ $key }}: {{ $value }}</p>
                            @endforeach
                        </div>
                    </div>
                    @endif
                    @if ($log->new_values)
                    <div class="form-group col-6">
                        <label for="depois">
                            @if ($log->old_values)
                            Depois da edição
                            @else
                            {{ $log->auditable_type_readable }} {{ $log->event_readable }}
                            @endif
                        </label>
                        <div class="text-dark">
                            @foreach ($log->new_values as $key => $value)
                            <p>{{ $key }}: {{ $value }}</p>
                            @endforeach
                        </div>
                    </div>
                    @endif
                </div>
                @button([
                'route' => 'admin.auditoria.index',
                'icon' => 'arrow-left',
                'label' => 'Voltar',
                'class' => 'btn-secondary'
                ])
                @endbutton
        </div>
        <hr>
        </section>
    </div>
</div>
</div>
@endsection
