@extends('layouts.admin')

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.atendimentos-odontologicos.index') }}">Atendimentos odontológicos</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.agendamentos-atendimentos.index', ['tipo' => 'ODONTOLOGICO']) }}">Agenda</a></li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Atendimentos
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                <form id="form-busca" class="form-row" action="{{ route('admin.atendimentos-odontologicos.index') }}">
                    <div class="col">
                        @button([
                        'route' => 'admin.agendamentos-atendimentos.index',
                        'routeParams' => ['tipo' => 'ODONTOLOGICO'],
                        'icon' => 'calendar',
                        'label' => 'Agenda',
                        'class' => 'btn-primary'
                        ])
                        @endbutton
                    </div>

                    <select class="form-control col-5" name="prestador_servico">
                        @foreach ($prestadores as $prestador)
                        <option value="{{ $prestador->id }}" {{ old('prestador_servico', request()->prestador_servico) == $prestador->id ? 'selected' : '' }}>{{ $prestador->nome }}</option>
                        @endforeach
                    </select>

                    <div class="col-md-4 float-right">
                        <div class="input-group mb-3">
                            <input type="text" name="busca" class="form-control" placeholder="Busca" value="{{ old('busca', request()->busca) }}">
                            <div class="input-group-append">
                                <button class="btn btn-outline-secondary" title="Filtrar"><i data-feather="search"></i></button>
                                <a href="{{ route('admin.atendimentos-odontologicos.index') }}" class="btn btn-outline-secondary" title="Limpar"><i data-feather="x"></i></a>
                            </div>
                        </div>
                    </div>
                </form>

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Paciente</th>
                            <th>Horário agendamento</th>
                            <th>Término atendimento</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($atendimentos as $atendimento)
                        <tr>
                            <td>{{ $atendimento->agendamento->agendavel->nome }}</td>
                            <td>{{ $atendimento->agendamento->inicio->format('d/m/Y H:i') }} - {{ $atendimento->agendamento->fim->format('H:i') }}</td>
                            <td>{{ $atendimento->created_at->format('d/m/Y H:i') }}</td>
                            <td>
                                @button([
                                'route' => 'admin.atendimentos-odontologicos.edit',
                                'routeParams' => ['atendimento' => $atendimento, 'agendamento' => $atendimento->agendamento],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ])
                                @endbutton
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>

                {{ $atendimentos->links() }}
            </section>
        </div>
    </div>
</div>
@endsection