@extends('layouts.admin')

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.atendimentos-odontologicos.index') }}">Atendimentos odontológicos</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.agendamentos-atendimentos.index', ['tipo' => 'ODONTOLOGICO']) }}">Agenda</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.atendimentos-odontologicos.create', ['agendamento' => $agendamento]) }}">Atender</a></li>
        <li class="breadcrumb-item active" aria-current="page">Histórico do paciente</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Histórico do paciente
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <div class="form-row">
                    <div class="form-group col-4">
                        <label for="nome">Nome</label>
                        <input type="text" name="nome" readonly class="form-control-plaintext" value="{{ $paciente->nome }}">
                    </div>
                </div>
                <div class="atendimentos mt-3">
                    @foreach ($atendimentos as $atendimento)
                    <div class="atendimentos row mt-3">
                        <div class="col-2">
                            {{ $atendimento->created_at->format('d/m/Y H:i') }}
                        </div>
                        <div class="col-10">
                            {{ $atendimento->tratamento_executado }}
                        </div>
                    </div>
                    @endforeach

                    @if($atendimentos->count() == 0)
                    <p>Não há atendimentos para esse processo</p>
                    @endif
                </div>
                {{ $atendimentos->links() }}
                <hr>
                @button([
                'route' => 'admin.atendimentos-odontologicos.create',
                'routeParams' => ['agendamento' => $agendamento],
                'icon' => 'arrow-left',
                'label' => 'Atendimento',
                'class' => 'btn-secondary'
                ])
                @endbutton
                @button([
                'route' => 'admin.agendamentos-atendimentos.show',
                'routeParams' => ['agendamento' => $agendamento],
                'icon' => 'arrow-left',
                'label' => 'Agendamento',
                'class' => 'btn-secondary'
                ])
                @endbutton
            </section>
        </div>
    </div>
</div>
@endsection