@extends('layouts.admin')

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.atendimentos-odontologicos.index') }}">Atendimentos odontológicos</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.agendamentos-atendimentos.index', ['tipo' => 'ODONTOLOGICO']) }}">Agenda</a></li>
        <li class="breadcrumb-item active" aria-current="page">Atender</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Atender
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.atendimentos-odontologicos.store', ['agendamento' => $agendamento]) }}" method="post">
                    @csrf
                    @alerts
                    @endalerts

                    <div class="form-row">
                        <div class="form-group col-4">
                            <label for="horario">Horário agendamento</label>
                            <input type="text" readonly class="form-control-plaintext" value="{{ $agendamento->inicio->format('d/m/Y - H:i') }} às {{ $agendamento->fim->format('H:i') }}">
                        </div>
                        <div class="form-group col-4">
                            <label for="prestador_servico_id">Prestador</label>
                            <select class="form-control" name="prestador_servico_id">
                                @foreach ($prestadores as $prestador)
                                    <option value="{{ $prestador->id }}" @if (old('prestador_servico_id', $agendamento->prestador_servico_id) == $prestador->id) selected @endif>{{ $prestador->nome }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-12">
                            <label for="tratamento_executado">Tratamento executado</label>
                            <textarea autofocus required class="form-control" rows="8" name="tratamento_executado">{{ old('tratamento_executado') }}</textarea>
                        </div>
                        <div class="form-group col-12">
                            <label for="tratamento_executado">Tipo executado anteriormente</label>
                            <textarea class="form-control" readonly rows="8" name="tratamento_executado_anteriormente">{{ optional($atendimentoAnterior)->tratamento_executado }}</textarea>
                        </div>
                    </div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.atendimentos-odontologicos.paciente',
                    'routeParams' => ['agendamento' => $agendamento],
                    'target' => '_blank',
                    'icon' => 'user',
                    'label' => 'Paciente',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.atendimentos-odontologicos.historico',
                    'routeParams' => ['agendamento' => $agendamento],
                    'target' => '_blank',
                    'icon' => 'list',
                    'label' => 'Histórico',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.anamnese-atendimento.create-edit',
                    'routeParams' => ['pessoa' => $paciente, 'tipo' => $paciente->tipo(), 'agendamento' => $agendamento->id],
                    'icon' => 'clipboard',
                    'label' => 'Anamnese',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.atendimentos-odontologicos.index',
                    'icon' => 'arrow-left',
                    'label' => 'Voltar para atendimentos',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection