@extends('layouts.admin')

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.agendamentos-atendimentos.index', ['tipo' => 'JURIDICO']) }}">Atendimento Jurídico</a></li>
        @if (request()->tipo == 'associado')
            <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.edit', ['servidor' => $processo->agendavel]) }}">{{ $processo->agendavel->nome }}</a></li>
        @else
            <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.funcionarios.edit', ['funcionario' => $processo->agendavel]) }}">{{ $processo->agendavel->nome }}</a></li>
        @endif
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.processos-juridicos.index', ['pessoa' => $processo->agendavel, 'tipo' => $processo->agendavel->tipo()]) }}">Processos</a></li>
        <li class="breadcrumb-item active" aria-current="page">Histórico de atendimento</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Histórico de atendimento do processo {{ $processo->numero }}
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @foreach ($atendimentos as $atendimento)
                    <div class="atendimentos row mt-3">
                        <div class="col-2">
                            {{ $atendimento->created_at->format('d/m/Y H:i') }}
                        </div>
                        <div class="col-10">
                            {{ $atendimento->anotacoes }}
                        </div>
                    </div>
                    @endforeach

                    @if($atendimentos->count() == 0)
                        <p>Não há atendimentos para esse processo</p>
                    @endif
                <hr>
                @button([
                'route' => 'admin.processos-juridicos.edit',
                'routeParams' => [
                    'pessoa' => $processo->agendavel, 
                    'tipo' => $processo->agendavel->tipo(), 
                    'id' => $processo->id, 
                    'agendamento' => request()->agendamento
                ],
                'icon' => 'arrow-left',
                'label' => 'Processo',
                'class' => 'btn-secondary'
                ])
                @endbutton
            </section>
        </div>
    </div>
</div>
@endsection