@extends('layouts.admin')

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.agendamentos-atendimentos.index', ['tipo' => 'JURIDICO']) }}">Atendimento Jurídico</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.agendamentos-atendimentos.show', ['agendamento' => $agendamento]) }}">Agendamento</a></li>
        <li class="breadcrumb-item active" aria-current="page">Atender</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Atender
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.atendimentos-juridicos.store', ['agendamento' => $agendamento, 'processo' => $processo]) }}" method="post">
                    @csrf
                    @alerts
                    @endalerts

                    <div class="form-row">
                        <div class="form-group col-4">
                            <label for="horario">Horário agendamento</label>
                            <input type="text" readonly class="form-control-plaintext" value="{{ $agendamento->inicio->format('d/m/Y - H:i') }} às {{ $agendamento->fim->format('H:i') }}">
                        </div>
                        <div class="form-group col-12">
                            <label for="anotacoes">Anotações *</label>
                            <textarea autofocus required class="form-control" rows="8" name="anotacoes">{{ old('anotacoes') }}</textarea>
                        </div>
                    </div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.processos-juridicos.edit',
                    'routeParams' => [
                            'pessoa' => $agendamento->agendavel, 
                            'tipo' => $agendamento->agendavel->tipo(), 
                            'id' => $processo->id,
                            'agendamento' => $agendamento,
                    ],
                    'icon' => 'arrow-left',
                    'label' => 'Processo',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection