@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/anamnese-atendimento/create-edit.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.atendimentos-odontologicos.index') }}">Atendimentos odontológicos</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.agendamentos-atendimentos.index', ['tipo' => 'ODONTOLOGICO']) }}">Agenda</a></li>
        <li class="breadcrumb-item active" aria-current="page">Anamnese</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Anamnese - {{ $agendavel->nome }}
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.anamnese-atendimento.store') }}" method="post">
                    @csrf
                    @alerts
                    @endalerts

                    <input type="hidden" name="pessoa" value="{{ $pessoa }}">
                    <input type="hidden" name="tipo" value="{{ $tipo }}">
                    <input type="hidden" name="agendamento" value="{{ $agendamento }}">

                    <table class="table table-borderless">
                        <thead>
                            <tr>
                                <th>Pergunta</th>
                                <th>Sim/Não</th>
                                <th class="w-50">Qual?</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($perguntas as $pergunta)
                            @php
                            $respostaPergunta = $respostas->where('pergunta_anamnese_id', $pergunta->id)->first();
                            @endphp
                            <tr>
                                <td>{{ $pergunta->descricao }}</td>
                                <td>
                                    <input type="checkbox" class="checkbox-resposta" {{ $respostaPergunta ? 'checked' : '' }} name="respostas[{{ $pergunta->id }}][resposta]">
                                </td>
                                <td>
                                    <input type="text" disabled maxlength="300" name="respostas[{{ $pergunta->id }}][qual]" class="form-control qual" value="{{ optional($respostaPergunta)->qual }}">
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @if (isset($agendamento))
                        @button([
                        'route' => 'admin.atendimentos-odontologicos.create',
                        'routeParams' => ['agendamento' => $agendamento],
                        'icon' => 'clipboard',
                        'label' => 'Fazer Atendimento',
                        'class' => 'btn-secondary'
                        ])
                        @endbutton
                    @endif
                    @button([
                    'route' => 'admin.anamnese-atendimento.impressao',
                    'routeParams' => ['tipo' => $tipo, 'pessoa' => $pessoa],
                    'target' => 'new',
                    'icon' => 'printer',
                    'label' => 'Imprimir',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.agendamentos-atendimentos.index',
                    'routeParams' => ['tipo' => 'ODONTOLOGICO'],
                    'icon' => 'calendar',
                    'label' => 'Novo Agendamento',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection