@extends('layouts.admin')

@push('css')
<link href="{{ asset('vendors/daterangepicker/daterangepicker.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('vendors/bootstrap-timepicker/css/bootstrap-timepicker.min.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('vendors/select2/dist/css/select2.min.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('css/admin/agendamentos-atendimentos-create-show.css') }}" rel="stylesheet" type="text/css">
@endpush

@push('js')
<script src="{{ asset('vendors/moment/min/moment-with-locales.min.js') }}"></script>
<script src="{{ asset('vendors/bootstrap-timepicker/js/bootstrap-timepicker.min.js') }}"></script>
<script src="{{ asset('vendors/daterangepicker/daterangepicker.js') }}"></script>
<script src="{{ asset('vendors/select2/dist/js/select2.full.min.js') }}"></script>
<script src="{{ asset('js/admin/agendamentos-atendimentos/create-show.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.agendamentos-atendimentos.index', ['tipo' => strtolower($tipo->getName())]) }}">Agendamentos de atendimentos</a></li>
        <li class="breadcrumb-item active" aria-current="page">Incluir</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Incluir agendamento {{ $tipo->getValue() }}
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form id="form-agendamento" action="{{ route('admin.agendamentos-atendimentos.store') }}" method="post">
                    @csrf
                    @alerts
                    @endalerts

                    <input type="hidden" id="hidden-pessoa-sem-anamnese" value="{{ session('pessoaSemAnamnese', false) }}">
                    <input type="hidden" id="hidden-pessoa-recem-agendada" value="{{ session('pessoa') }}">
                    <input type="hidden" id="hidden-tipo-pessoa-recem-agendada" value="{{ session('tipo') }}">
                    <input type="hidden" id="hidden-exception-message" value="{{ session('exceptionMessage') }}">
                    <input type="hidden" id="hidden-ultimo-atendimento-proximo" value="{{ session('ultimoAtendimentoProximo') }}">
                    <input type="hidden" name="permiteAgendamentoProximo" id="hidden-permite-agendamento-proximo" value="{{ session('permiteAgendamentoProximo', 0) }}">
                    <input type="hidden" id="hidden-exception-sobrepoe-juridico-message" value="{{ session('exceptionSobrepoeHorarioJuridicoMessage') }}">
                    <input type="hidden" name="em_tratamento" id="hidden-em-tratamento" value="{{ session('emTratamento', 0) }}">
                    <input type="hidden" name="emergencia" id="hidden-emergencia" value="{{ session('emergencia', 0) }}">
                    <input type="hidden" name="extraordinario" id="hidden-extraordinario" value="{{ session('extraordinario', 0) }}">
                    <input type="hidden" id="hidden-route-busca" value="{{ route('admin.agendamentos-atendimentos.busca-pessoa') }}">
                    <input type="hidden" id="hidden-route-busca-tipo-id" value="{{ url('admin/agendamentos-atendimentos/busca-pessoa/') }}">
                    <input type="hidden" name="tipo_agendamento" value="{{ $tipo->getName() }}">
                    <input type="hidden" id="hidden-pessoa-selecionada-anteriormente" value="{{ old('pessoa') }}">
                    <input type="hidden" id="hidden-agendamento-recem-criado" value="{{ session('agendamento') }}">
                    <input type="hidden" id="hidden-feriados" value="{{ $feriados }}">

                    <div class="form-row">
                        <div class="form-group col-2">
                            <label for="select-tipo">Tipo</label>
                            <select autofocus class="form-control" id="select-tipo" name="tipo">
                                <option value="associado" {{ old('tipo') == 'associado' ? 'selected' : '' }}>Associado</option>
                                <option value="funcionario" {{ old('tipo') == 'funcionario' ? 'selected' : '' }}>Funcionário</option>
                                <option value="dependente" {{ old('tipo') == 'dependente' ? 'selected' : '' }}>Dependente</option>
                            </select>
                        </div>
                        <div class="form-group col-5">
                            <label for="pessoa">Pessoa *</label>
                            <select required name="pessoa" id="select-pessoa" class="form-control @error('pessoa') is-invalid @enderror"></select>
                        </div>
                        @if ($tipo->isOdontologico())
                        <div class="form-group col-5">
                            <label for="prestador_servico_id">Profissional</label>

                            <select class="form-control" name="prestador_servico_id">
                                @foreach ($prestadores as $prest)
                                <option value="{{ $prest->id }}" {{ old('prestador_servico_id', $prestador_id) == $prest->id ? 'selected' : '' }}>{{ $prest->nome }}</option>
                                @endforeach
                            </select>
                        </div>
                        @endif
                        <div class="form-group col-2">
                            <label for="data">Data *</label>
                            <input type="text" required autocomplete="off" name="data" class="form-control data @error('data') is-invalid @enderror" value="{{ old('data') ?? $data ?? '' }}">
                        </div>
                        <div class="form-group col-2">
                            <label for="hora_inicio">Hora início *</label>
                            <input type="text" required id="input-hora-inicio" autocomplete="off" name="hora_inicio" class="form-control hora @error('hora_inicio') is-invalid @enderror" value="{{ old('hora_inicio') ?? $hora ?? ''}}">
                        </div>
                        <div class="form-group col-2">
                            <label for="hora_fim">Hora fim *</label>
                            <input type="text" required id="input-hora-fim" autocomplete="off" name="hora_fim" class="form-control hora @error('hora_fim') is-invalid @enderror" value="{{ old('hora_fim') }}">
                        </div>
                        @if ($tipo->isOdontologico())
                        <div class="form-group col-2">
                            <label for="emergencia">Emergência *</label>
                            <select name="emergencia" class="form-control">
                                <option value="0" @if (! old('emergencia')) selected @endif>NÃO</option>
                                <option value="1" @if ( old('emergencia')) selected @endif>SIM</option>
                            </select>
                        </div>
                        @endif
                    </div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.agendamentos-atendimentos.index',
                    'routeParams' => ['tipo' => $tipo->getName()],
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
<div class="modal" id="modal-sucesso" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <p>{{ session('status') }}</p>
                <p class="mt-2">Paciente não tem anamnese, deseja preencher agora?</p>
            </div>
            <div class="modal-footer">
                <button type="button" id="btn-criar-anamnese" data-url="{{ url('admin/agendamentos-atendimentos/atendimentos-odontologicos/anamnese/') }}" class="btn btn-primary">Sim</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
            </div>
        </div>
    </div>
</div>
<div class="modal" id="modal-pergunta" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <p>{{ session('exceptionMessage') }}</p>
                <p class="mt-2">Deseja continuar e agendar o atendimento mesmo assim?</p>
            </div>
            <div class="modal-footer">
                <button type="submit" form="form-agendamento" class="btn btn-primary">Sim</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
            </div>
        </div>
    </div>
</div>
<div class="modal" id="modal-agendamento-extraordinario" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <div class="form-row">
                    <p>{{ session('exceptionMessage') }}</p>
                    <p class="mt-2">Deseja continuar e agendar o atendimento mesmo assim?</p>
                </div>
                <div class="form-row">
                    <div class="form-group col-12">
                        <label for="motivo_extraordinario">Motivo *</label>
                        <input type="text" form="form-agendamento" id="text-motivo-extraordinario" maxlength="100" autocomplete="off" name="motivo_extraordinario" class="form-control @error('motivo_extraordinario') is-invalid @enderror" value="{{ old('motivo_extraordinario') }}">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" form="form-agendamento" class="btn btn-primary">Sim</button>
                <button type="button" class="btn btn-secondary" id="btnCancelarAgendamentoExtraordinario" data-dismiss="modal">Não</button>
            </div>
        </div>
    </div>
</div>
@endsection