@extends('layouts.admin')

@push('js')
<script src='{{ asset("vendors/fullcalendar/locales/pt-br.js") }}'></script>
<script src='{{ asset("vendors/fullcalendar/core.min.js") }}'></script>
<script src='{{ asset("vendors/fullcalendar/daygrid.min.js") }}'></script>
<script src="{{ asset('js/admin/agenda-diretoria/index.js') }}"></script>
@endpush

@push('css')
<link href='{{ asset("vendors/fullcalendar/core.min.css") }}' rel='stylesheet' />
<link href='{{ asset("vendors/fullcalendar/daygrid.min.css") }}' rel='stylesheet' />
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Agenda da diretoria</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Agenda da diretoria
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <div id="alert-erro-carregamento" class="alert alert-danger d-none font-weight-bold" role="alert"></div>

                @alerts
                @endalerts

                <div class="row">
                    <div class="col">
                        @button([
                        'route' => 'admin.agenda-diretoria.create',
                        'icon' => 'plus',
                        'label' => 'Incluir evento',
                        'class' => 'btn-primary'
                        ])
                        @endbutton
                    </div>
                    <div class="col">
                        <div class="btn-group btn-group-toggle float-right" data-toggle="buttons">
                            <label class="btn btn-outline-primary active">
                                <input id="check-diretoria" type="checkbox" checked> Diretoria
                            </label>
                            <label class="btn btn-outline-warning">
                                <input id="check-feriados" type="checkbox"> Feriados
                            </label>
                        </div>
                    </div>
                </div>

                <input type="hidden" id="hidden-event-source-diretoria" value="{{ route('admin.agenda-diretoria.load') }}">
                <input type="hidden" id="hidden-event-source-feriados" value="{{ route('admin.feriados.load') }}">

                <div class="mt-3" id="calendario"></div>
            </section>
        </div>
    </div>
</div>
@endsection