$(function () {
    $('.registro').mask('000000', { reverse: true, clearIfNotMatch: true });
    $('.data').mask('00/00/0000', { clearIfNotMatch: true });
    
    $('#select-unidade-organizacional').select2();
    $('#select-unidade-organizacional').change(function () {
        var urlApi = $('#hidden-url-api-endereco-uor').val();

        $.getJSON(urlApi + '/' + $(this).val())
            .done(function (data) {
                $('#endereco-lotacao').val(data.endereco);
                $('#btn-escolher-endereco-lotacao').show();
            })
            .fail(function () {
                $('#endereco-lotacao').val("Unidade não possui endereço cadastrado");
            });
    }).change();

    $('#select-readaptado').change(function () {
        if ($(this).val() == '1') {
            $('#div-cargo-readaptado').show();
        } else {
            $('#select-cargo-readaptado').val('');
            $('#div-cargo-readaptado').hide();
        }
    }).change();

    $('#btn-mesmo-endereco-unidade').click(function() {
        $('.endereco').hide();
        $('.endereco input').val('');

        $('#div-mesmo-endereco-unidade').hide();
        $('#div-outro-endereco').show();
        $('#hidden-usar_endereco_unidade').val(1)
    });

    $('#btn-escolher-endereco-lotacao').click(function () {
        $('.endereco').show();
        $('#div-mesmo-endereco-unidade').show();
        $('#div-outro-endereco').hide();
        $('#hidden-usar_endereco_unidade').val(0)
    });

    if ($('#text-cep').val() || $('#hidden-usar_endereco_unidade').val() == '0') {
        $('.endereco').show();

        $('#div-mesmo-endereco-unidade').show();
        $('#div-outro-endereco').hide();
    } else {
        $('.endereco').hide();

        $('#div-mesmo-endereco-unidade').hide();
        $('#div-outro-endereco').show();
    }

    $('#select-regime').change(function () {
        if ($(this).val() == '3') { // Aposentado
            $('#div-aposentado').show();
            $('#div-data-desligamento').hide();
            $('#text-data-desligamento').val('');
        } else {
            $('#div-aposentado').hide();
            $('#div-data-desligamento').show();
        }
    }).change();

    $('#select-unidade-organizacional').change(function () {
        let secretaria = $('#select-unidade-organizacional option:selected').attr('data-secretaria');
        console.log(secretaria);
        $('#text-secretaria').val(secretaria);
    }).change();
});