$(function() {
    $('.cpf').mask('000.000.000-00', { reverse: true, clearIfNotMatch: true });
    $('.data').mask('00/00/0000', { clearIfNotMatch: true });
    $('.registro').mask('000000', { clearIfNotMatch: true });

    $('#modal-sucesso-filiacao').modal({
        'show': false
    });

    $('#modal-impressao-documentos').modal({
        'show': false
    });

    $('#naturalidade').on('keypress', function(e) {
        var naoPermitidos = ['/', '\\', '(', ')', '_', '-', '*', '%', '#', '@', '!'];
        if (naoPermitidos.indexOf(e.key) !== -1) {
            return false;
        }
    });

    $('#btn-imprimir-documentos').click(function(e) {
        e.preventDefault();
        $('#modal-impressao-documentos').modal('show');
    });

    function temSuporteGetUserMedia() {
        return !!(navigator.mediaDevices &&
            navigator.mediaDevices.getUserMedia);
    }

    $('#btn-abrir-captura-foto').click(function() {
        if (temSuporteGetUserMedia()) {
            const img = document.querySelector('#div-foto img')
            const hiddenImagem = document.querySelector('#hidden-imagem-camera')
            const video = document.querySelector('#modal-captura-foto video');
            const canvas = document.createElement('canvas');

            navigator.mediaDevices.getUserMedia({ video: true }).
                then(function(stream) {
                    video.srcObject = stream;
                    $('#modal-captura-foto').modal('show');
                });

            $('#btn-captura-foto').click(function() {
                canvas.width = video.videoWidth;
                canvas.height = video.videoHeight;
                canvas.getContext('2d').drawImage(video, 0, 0);
                // Other browsers will fall back to image/png
                img.src = canvas.toDataURL('image/webp');
                hiddenImagem.value = canvas.toDataURL('image/webp');


                $('#modal-captura-foto').modal('hide');
            });

        } else {
            alert('getUserMedia() is not supported by your browser');
        }
    });

    $('#btn-remover-foto').click(function() {
        $('#hidden-imagem-camera').val('');
        $('#hidden-remover-imagem').val(true);
        $('#div-foto img').prop('src', '');
    });

    if ($('#hidden-sucesso-filiacao').val() == true) {
        $('#modal-sucesso-filiacao').modal('show');
    }

    if ($('#hidden-sucesso-inclusao').val() == true) {
        $('#modal-pergunta').modal('show');
    }

    $('#btn-nao-afiliar').click(function() {
        $('#modal-pergunta').modal('hide');
    });

    $('#btn-voltar').click(function() {
        top.location = $('#hidden-rota-voltar').val()
    });

    $('#modal-excluir-endereco').modal({
        'show': false
    });

    $('#modal-termos-assinar').modal({
        'show': false
    });

    if ($('#hidden-termos-assinar').val()) {
        $('#modal-termos-assinar').modal('show');
    }

    $('.btn-excluir-endereco').click(function(e) {
        e.preventDefault();
        $('#form-excluir-endereco').prop('action', $(this).prop('href'));
        $('#modal-excluir-endereco').modal('show');
    });

    $('#modal-excluir-registro').modal({
        'show': false
    });

    $('#modal-captura-foto').modal({
        'show': false
    });

    $('.btn-excluir-registro').click(function(e) {
        e.preventDefault();
        $('#form-excluir-registro').prop('action', $(this).prop('href'));
        $('#modal-excluir-registro').modal('show');
    });

    $('#modal-restaurar-servidor').modal({
        'show': false
    });

    $('.btn-restaurar-servidor').click(function(e) {
        e.preventDefault();
        $('#modal-restaurar-servidor').modal('show');
    });
});
