$(function () {
    $('.cpf').mask('000.000.000-00', { reverse: true, clearIfNotMatch: true });
    $('.data').mask('00/00/0000', { clearIfNotMatch: true });
    $('.registro').mask('000000', { clearIfNotMatch: true });
    $('#div-alert-lotacao').hide();

    $('#naturalidade').on('keypress', function(e) {
        var naoPermitidos = ['/', '\\', '(', ')', '_', '-', '*', '%', '#', '@', '!'];
        if (naoPermitidos.indexOf(e.key) !== -1) {
            return false;
        }
    });

    $('#modal-logradouro-lotacao').modal({
        keyboard: false,
        show: false,
        backdrop: 'static',
    });

    if (! $('#select-unidade-organizacional').val()) {
        $('#btn-escolher-endereco-lotacao').hide();
    }

    $('#select-unidade-organizacional').select2();
    $('#select-unidade-organizacional').change(function() {
        if ($('#text-cep-lotacao').val()) {
            var extenso = enderecoExtenso($('#text-logradouro-lotacao').val(),
                $('#text-bairro-lotacao').val(),
                $('#text-cidade-lotacao').val(),
                $('#select-estado-lotacao').val(),
                $('#text-numero-lotacao').val(),
                $('#text-cep-lotacao').val());
            $('#endereco-lotacao').val(extenso);
        } else {
            var urlApi = $('#hidden-url-api-endereco-uor').val();
    
            $.getJSON(urlApi + '/' + $(this).val())
            .done(function(data) {
                $('#endereco-lotacao').val(data.endereco);
                $('#btn-escolher-endereco-lotacao').show();
            })
            .fail(function() {
                $('#btn-escolher-endereco-lotacao').show();
                $('#endereco-lotacao').val("Unidade não possui endereço cadastrado");
            });
        }

    }).change();

    $('#btn-escolher-endereco-lotacao').click(function() {
        $('#modal-logradouro-lotacao').modal('show');
    });

    function temSuporteGetUserMedia() {
        return !!(navigator.mediaDevices &&
            navigator.mediaDevices.getUserMedia);
    }

    $('#btn-abrir-captura-foto').click(function () {
        if (temSuporteGetUserMedia()) {
            const img = document.querySelector('#div-foto img')
            const hiddenImagem = document.querySelector('#hidden-imagem-camera')
            const video = document.querySelector('#modal-captura-foto video');
            const canvas = document.createElement('canvas');

            navigator.mediaDevices.getUserMedia({ video: true }).
                then(function (stream) {
                    video.srcObject = stream;
                    $('#modal-captura-foto').modal('show');
                });

            $('#btn-captura-foto').click(function () {
                canvas.width = video.videoWidth;
                canvas.height = video.videoHeight;
                canvas.getContext('2d').drawImage(video, 0, 0);
                // Other browsers will fall back to image/png
                img.src = canvas.toDataURL('image/webp');
                hiddenImagem.value = canvas.toDataURL('image/webp');

                $('#modal-captura-foto').modal('hide');
            });

        } else {
            alert('Não foi possível obter abrir a câmera pelo seu navegador');
        }
    });

    $('#btn-remover-foto').click(function () {
        $('#hidden-imagem-camera').val('');
        $('#div-foto img').prop('src', '');
    });

    $('#select-associado').change(function () {
        if ($(this).val() == '1') {
            $('#text-data-admissao-sindicato').prop('disabled', false);
            $('#text-motivo-filiacao').prop('disabled', false);
        } else {
            $('#text-data-admissao-sindicato').prop('disabled', true);
            $('#text-motivo-filiacao').prop('disabled', true);
        }
    }).change();

    $('#select-readaptado').change(function() {
        if ($(this).val() == '1') {
            $('#div-cargo-readaptado').show();
        } else {
            $('#select-cargo-readaptado').val('');
            $('#div-cargo-readaptado').hide();
        }
    }).change();

    $('#select-regime').change(function () {
        if ($(this).val() == '3') { // Aposentado
            $('#div-aposentado').show();
            $('#div-data-desligamento').hide();
            $('#text-data-desligamento').val('');
        } else {
            $('#div-aposentado').hide();
            $('#div-data-desligamento').show();
        }
    }).change();

    $('#select-unidade-organizacional').change(function () {
        let secretaria = $('#select-unidade-organizacional option:selected').attr('data-secretaria');
        console.log(secretaria);
        $('#text-secretaria').val(secretaria);
    }).change();

    $('#btn-busca-cep-lotacao').on('click', function () {
        $(this).prop('disabled', true);

        $.getJSON($('#hidden-url-logradouro-api-cep').val(), {
            'cep': $('#text-cep-lotacao').val()
        }, function (data) {
            $('#btn-busca-cep-lotacao').prop('disabled', false);

            if (data.length > 0) {
                var endereco = data[0];
                $('#text-logradouro-lotacao').val(endereco.log_tipo_logradouro + ' ' + endereco.logradouro);
                $('#text-bairro-lotacao').val(endereco.bairro);
                $('#text-cidade-lotacao').val(endereco.cidade);
                $('#select-estado-lotacao').val(endereco.uf);
            } else {
                $('#text-logradouro-lotacao').val('');
                $('#text-bairro-lotacao').val('');
                $('#text-cidade-lotacao').val('');
                $('#select-estado-lotacao').val('SP');
            }
        });
    });

    $('#btn-seleciona-logradouro-lotacao').on('click', function () {
        if (validaLogradouroLotacao()) {
            $('#div-alert-lotacao').hide();
            $('#div-alert-lotacao p').html("");
            var extenso = enderecoExtenso($('#text-logradouro-lotacao').val(),
                $('#text-bairro-lotacao').val(),
                $('#text-cidade-lotacao').val(),
                $('#select-estado-lotacao').val(),
                $('#text-numero-lotacao').val(),
                $('#text-cep-lotacao').val());
            $('#endereco-lotacao').val(extenso);
            $('#modal-logradouro-lotacao').modal('hide');
        } else {
            $('#div-alert-lotacao p').html("Preencha todos os campos de endereço")
            $('#div-alert-lotacao').show();
        }
    });

    $('#btn-cancelar-selecao-logradouro').click(function () {
        $('#div-alert-lotacao').hide();
        $('#div-alert-lotacao p').html("");

        $('#text-cep-lotacao').val('');
        $('#text-logradouro-lotacao').val('');
        $('#text-bairro-lotacao').val('');
        $('#text-cidade-lotacao').val('');
        $('#select-estado-lotacao').val('SP');
    })

    function validaLogradouroLotacao() {
        if ($('#text-cep-lotacao').val()
            && $('#text-logradouro-lotacao').val()
            && $('#text-cidade-lotacao').val()
            && $('#text-numero-lotacao').val()
            && $('#select-estado-lotacao').val()) {
            return true;
        }

        return false;
    }

    function enderecoExtenso(logradouro, bairro, cidade, estado, numero, cep) {
        numero = numero ? numero : 'S/N';
        return logradouro + ", " + numero + ". " + bairro + ", " + cidade + " - " + estado + ". CEP " + cep;
    }
});
