$(function () {
    var logradouros;

    $('#div-resultado').hide();
    $('#div-alert').hide();

    $('#btn-busca-cep').on('click', function() {
        var cep = $('#text-cep').val();

        if (cep) {
            $(this).prop('disabled', true);

            $.getJSON($('#hidden-url-logradouro-api-cep').val(), {
                'cep': $('#text-cep').val()
            }, function(data) {
                $('#btn-busca-cep').prop('disabled', false);
                
                if (data.length > 0) {
                    var endereco = data[0];
                    $('#text-logradouro').val(endereco.log_tipo_logradouro + ' ' + endereco.logradouro);
                    $('#text-bairro').val(endereco.bairro);
                    $('#text-cidade').val(endereco.cidade);
                    $('#select-estado').val(endereco.uf);
                } else {
                    $('#text-logradouro').val('');
                    $('#text-bairro').val('');
                    $('#text-cidade').val('');
                    $('#select-estado').val('SP');
                }
            });
        } else {
            $('#modal-busca-logradouro').modal('show');
            $('#text-busca-logradouro').focus();
        }
    });

    $('#btn-busca-logradouro').on('click', function() {
        $('#div-alert').hide();
        $('#table-resultado tbody').html('');

        if (! $('#text-busca-logradouro').val()) {
            $('#div-alert p').html('Informe parte do nome do logradouro');
            $('#div-alert').show();
        }

        $.getJSON($('#hidden-url-busca-logradouro-api').val(), {
            'logradouro': $('#text-busca-logradouro').val(),
            'numero': $('#text-busca-numero').val(),
        }, function (data) {
            logradouros = data;
            
            if (data.length > 0) {
                $(data).each(function(i, logradouro) {
                    $('#table-resultado tbody').append("\
                        <tr>\
                            <td>" + logradouro.log_tipo_logradouro + " " + logradouro.logradouro + "</td>\
                            <td>" + logradouro.bairro + "</td>\
                            <td>" + logradouro.cidade + "</td>\
                            <td>" + logradouro.uf + "</td>\
                            <td>" + logradouro.cep + "</td>\
                            <td><button type='button' class='btn-seleciona-logradouro btn btn-primary' value='" + i + "'>Selecionar</button></td>\
                        </tr>\
                    ")
                });
                $('#div-resultado').show();
            } else {
                $('#div-alert p')
                    .html('Nenhum logradouro foi encontrado');
                $('#div-alert').show();
            }
        });
    });

    $(document).on('click', '.btn-seleciona-logradouro', function() {
        console.log($('.btn-seleciona-logradouro'));
        
        var logradouro = logradouros[$(this).val()];
        var cep = logradouro.cep.substring(0, 5) + '-' + logradouro.cep.substring(5, 8);
        
        $('#modal-busca-logradouro').modal('hide');

        $('#text-cep').val(cep);
        $('#text-logradouro').val(logradouro.log_tipo_logradouro + ' ' + logradouro.logradouro);
        $('#text-bairro').val(logradouro.bairro);
        $('#text-cidade').val(logradouro.cidade);
        $('#text-estado').val(logradouro.uf);
    })
});