$(function() {
    $('.data').mask('00/00/0000');
    $('.dinheiro').mask('000.000,00', { reverse: true });

    moment.locale('pt-br');

    $('.data').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
    });

    $('#select-status').change(function() {
        // Pago
        if ($(this).val() == '2') {
            $('#div-data-pagamento').show();
            $('#div-valor-pago').show();
            $('#div-forma-pagamento').show();

            if (!$('#text-valor.pago').val()) {
                $('#text-valor-pago').val($('#text-valor').val());
            }
        } else {
            $('#div-data-pagamento').hide();
            $('#div-valor-pago').hide();
            $('#div-forma-pagamento').hide();
        }
    }).change();

    $('#select-tipo-despesa').change(function() {
        // Extra
        if ($(this).val() == '2') {
            $('#div-responsavel-despesa').show();
        } else {
            $('#div-responsavel-despesa').hide();
        }
    }).change();

    $('#select-plano-contas').change(function() {
        var urlApi = $('#url-api-classificacoes').val() + "/" + $(this).val() + '/classificacoes';
        var classificacaoSelecionada = $('#hidden-classificacao-selecionada').val();
        var options = "";
        var selected = "";

        $.getJSON(urlApi).done(function(data) {
            $.each(data, function(i, classificacao) {
                if (classificacaoSelecionada == classificacao.id) {
                    selected = "selected";
                } else {
                    selected = "";
                }
                options += "<option value='" + classificacao.id + "' " + selected + ">" + classificacao.nome + "</option>";
            });
            $('#select-classificacao-contas-id').html(options);
        });
    }).change();
});
