$(function () {
    moment.locale('pt-br');

    $('#modal-excluir').modal({
        'show': false
    });

    $('.btn-excluir').click(function() {
        $('#modal-excluir').modal('show');
    })

    $('#select-pessoa').select2({
        ajax: {
            url: $('#hidden-route-busca').val(),
            dataType: 'json',
            data: function (params) {
                return {
                    q: params.term,
                    page: params.page,
                    tipo: $('#select-tipo').val()
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        },
        minimumInputLength: 3,
        language: {
            inputTooShort: function () {
                return "Digite 3 ou mais caracteres para buscar a pessoa";
            }
        }
    });

    $(document).on('focus', '.select2.select2-container', function (e) {
        if (e.originalEvent && $(this).find(".select2-selection--single").length > 0) {
            $(this).siblings('select').select2('open');
        }
    });

    $('.data').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        minDate: moment(),
        locale: {
            format: 'DD/MM/YYYY'
        }
    });

    $('.hora').timepicker({
        minuteStep: 30,
        template: false,
        showMeridian: false,
        defaultTime: false,
    });

    $('#input-hora-inicio').blur(function() {
        if ($(this).val() && ! $('#input-hora-fim').val()) {
            var hora = moment($(this).val(), 'HH:mm').add(30, 'm').format('HH:mm');
            $('#input-hora-fim').timepicker('setTime', hora);
        }
    });

    $('.btn-excluir').click(function (e) {
        e.preventDefault();
        $('#modal-excluir').modal('show');
    });

    $('#select-convidados').select2({
        tags: true
    });
});