document.addEventListener('DOMContentLoaded', function () {
    moment.locale('pt-br');
    var calendarEl = document.getElementById('calendario');

    var calendar = new FullCalendar.Calendar(calendarEl, {
        plugins: ['dayGrid', 'timeGrid', 'interaction'],
        timeZone: 'UTC',
        defaultView: 'timeGridDay',
        selectable: true,
        minTime: '08:00',
        maxTime: '18:00',
        slotLabelInterval: '00:30',
        slotLabelFormat: {
            omitZeroMinute: false,
            hour: 'numeric',
            minute: '2-digit',
            meridiem: 'short'
        },
        header: {
            left: 'prev,next today incluir atendimentos',
            center: 'title',
            right: 'timeGridDay,timeGridWeek,dayGridMonth'
        },
        eventSources: [
            {
                url: document.getElementById('hidden-event-source').value,
                method: 'GET'
            },
        ]
    });

    calendar.setOption('locale', 'pt-br');
    calendar.render();
});