<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class AlterMatriculasMotivoFiliacaoForeignKey extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasColumn('matriculas', 'motivo_filiacao')) {
            Schema::table('matriculas', function (Blueprint $table) {
                $table->dropColumn('motivo_filiacao');
            });
        }

        Schema::table('matriculas', function (Blueprint $table) {
            $table->bigInteger('motivo_filiacao_id')->default();
        });

        Schema::table('matriculas', function (Blueprint $table) {
            DB::table('matriculas')->update(['motivo_filiacao_id' => 1]);
            $table->foreign('motivo_filiacao_id')->references('id')->on('motivos_filiacao');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('matriculas', 'motivo_filiacao')) {
            Schema::table('matriculas', function (Blueprint $table) {
                $table->dropColumn('motivo_filiacao');
            });
        }

        Schema::table('matriculas', function (Blueprint $table) {
            $table->string('motivo_filiacao', 100)->default('');
        });
    }
}
