<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAtendimentosJuridicosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('atendimentos_juridicos', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('agendamento_atendimento_id')->nullable();
            $table->foreign('agendamento_atendimento_id')
                    ->references('id')
                    ->on('agendamentos_atendimentos');
            $table->bigInteger('processo_juridico_id')->nullable();
            $table->foreign('processo_juridico_id')
                    ->references('id')
                    ->on('processos_juridicos');
            $table->text('anotacoes');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('atendimentos_juridicos');
    }
}
