<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterAgendamentosAtendimentosAddExtraordinario extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('agendamentos_atendimentos', function (Blueprint $table) {
            $table->boolean('extraordinario')->default(false);
            $table->string('motivo_extraordinario', 100)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('agendamentos_atendimentos', function (Blueprint $table) {
            $table->dropColumns(['extraordinario', 'motivo_extraordinario']);
        });
    }
}
