<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterMensalidadesNiveisModifyNiveis extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('mensalidades_niveis', function (Blueprint $table) {
            $table->renameColumn('nivel', 'nivel_salarial_id');
        });

        Schema::table('mensalidades_niveis', function (Blueprint $table) {
            $table->foreign('nivel_salarial_id')->references('id')->on('niveis_salariais');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('mensalidades_niveis', function (Blueprint $table) {
            $table->dropForeign(['nivel_salarial']);
            $table->renameColumn('nivel_salarial', 'nivel');
        });
    }
}
