<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMensalidadesNiveisTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mensalidades_niveis', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->smallInteger('nivel'); // NivelSalarialEnum
            $table->decimal('valor');
            $table->date('inicio_vigencia');
            $table->date('termino_vigencia')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mensalidades_niveis');
    }
}
