<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterMatriculasAddMotivoReligamentoExtraordinario extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('matriculas', function (Blueprint $table) {
            $table->string('motivo_religamento_extraordinario', 150)->nullable();
            $table->date('data_religamento_extraordinario')->nullable();
            $table->boolean('religamento_extraordinario')->default(false);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('matriculas', function (Blueprint $table) {
            $table->dropColumn(['motivo_religamento_extraordinario',
                                'data_religamento_extraordinario',
                                'religamento_extraordinario']);
        });
    }
}
