<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterAtendimentosOdontologicosAddPrestadorServico extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('atendimentos_odontologicos', function (Blueprint $table) {
            $table->bigInteger('prestador_servico_id')->nullable();
            $table->foreign('prestador_servico_id')
                ->references('id')
                ->on('prestadores_servicos');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('atendimentos_odontologicos', function (Blueprint $table) {
            $table->dropColumn('prestador_servico_id');
        });
    }
}
