<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterProcessosJuridicosResultadoPagamentoNullable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('processos_juridicos', function (Blueprint $table) {
            $table->smallInteger('resultado')->nullable()->change();
            $table->date('data_pagamento')->nullable()->change();
            $table->text('anotacoes')->nullable()->change();
            $table->dropColumn('valor_pago');
        });

        Schema::table('processos_juridicos', function (Blueprint $table) {
            $table->decimal('valor_pago', 10, 2)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::disableForeignKeyConstraints();
        
        Schema::table('processos_juridicos', function (Blueprint $table) {
            $table->smallInteger('resultado')->nullable(false)->change();
            $table->date('data_pagamento')->nullable(false)->change();
            $table->text('anotacoes')->nullable(false)->change();
            $table->dropColumn('valor_pago');
        });

        Schema::table('processos_juridicos', function (Blueprint $table) {
            $table->decimal('valor_pago', 10, 2);
        });

        Schema::enableForeignKeyConstraints();
    }
}
