<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateConveniosPessoasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('convenios_pessoas', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('conveniavel_type');
            $table->bigInteger('conveniavel_id');
            $table->bigInteger('convenio_id');
            $table->foreign('convenio_id')
                    ->references('id')
                    ->on('convenios');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('convenios_pessoas');
    }
}
