<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDocumentosAssociadosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('documentos_associados', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('tipo_documento_id');
            $table->foreign('tipo_documento_id')
                    ->references('id')
                    ->on('tipos_documentos');
            $table->bigInteger('servidor_id');
            $table->foreign('servidor_id')
                    ->references('id')
                    ->on('servidores');
            $table->string('caminho');
            $table->string('observacoes', 100)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('documentos_associados');
    }
}
