<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMatriculasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('matriculas', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('servidor_id');
            $table->foreign('servidor_id')
                    ->references('id')
                    ->on('servidores');
            $table->date('data_filiacao');
            $table->string('motivo_filiacao', 100);
            $table->date('data_desligamento')->nullable();
            $table->string('motivo_desligamento', 100)->nullable();
            $table->smallInteger('tipo_desligamento')->nullable(); // TipoDesligamentoSindicatoEnum
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('matriculas');
    }
}
