<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterServidoresApenasNomeCpfNotNull extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('servidores', function (Blueprint $table) {
            $table->string('rg', 11)->nullable()->change();
            $table->string('nome_mae', 150)->nullable()->change();
            $table->date('data_nascimento')->nullable()->change();
            $table->string('naturalidade', 150)->nullable()->change();
            $table->string('nacionalidade', 150)->nullable()->change();
            $table->smallInteger('estado_civil')->nullable()->change();
            $table->smallInteger('sexo')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('servidores', function (Blueprint $table) {
            $table->string('rg', 11)->nullable(false)->change();
            $table->string('nome_mae', 150)->nullable(false)->change();
            $table->date('data_nascimento')->nullable(false)->change();
            $table->string('naturalidade', 150)->nullable(false)->change();
            $table->string('nacionalidade', 150)->nullable(false)->change();
            $table->smallInteger('estado_civil')->nullable(false)->change();
            $table->smallInteger('sexo')->nullable(false)->change();
        });
    }
}
