<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterAgendamentosAtendimentosAddMotivoCancelamento extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('agendamentos_atendimentos', function (Blueprint $table) {
            $table->bigInteger('motivo_cancelamento_id')->nullable();
            $table->foreign('motivo_cancelamento_id')
                    ->references('id')
                    ->on('motivos_cancelamentos_agendamentos');
            $table->string('observacao_cancelamento', 150)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('agendamentos_atendimentos', function (Blueprint $table) {
            $table->dropColumn(['motivo_cancelamento_id', 'observacao_cancelamento']);
        });
    }
}
