<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterRespostasAnamneseDropAgendamentoAddAnamnese extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('respostas_anamnese', function (Blueprint $table) {
            $table->dropColumn('agendamento_atendimento_id');
            $table->bigInteger('anamnese_id')->nullable();
            $table->foreign('anamnese_id')
                ->references('id')
                ->on('anamneses');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('respostas_anamnese', function (Blueprint $table) {
            $table->bigInteger('agendamento_atendimento_id')->nullable();
            $table->foreign('agendamento_atendimento_id')
                    ->references('id')
                    ->on('agendamentos_atendimentos');
            $table->dropColumn('anamnese_id');
        });
    }
}
