<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAtendimentosOdontologicosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('atendimentos_odontologicos', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('agendamento_atendimento_id')->nullable();
            $table->foreign('agendamento_atendimento_id')
                ->references('id')
                ->on('agendamentos_atendimentos');
            $table->text('tratamento_executado');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('atendimentos_odontologicos');
    }
}
