<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateHorariosTrabalhoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('horarios_trabalho', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('trabalhavel_id');
            $table->string('trabalhavel_type'); // Funcionario, PrestadorServico
            $table->string('dia_semana', 7); // DiaSemanaEnum
            $table->time('inicio');
            $table->time('fim');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('horarios_trabalho');
    }
}
