<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAgendamentosAtendimentosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('agendamentos_atendimentos', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->dateTime('inicio');
            $table->dateTime('fim');
            $table->string('agendavel_type');
            $table->bigInteger('agendavel_id');
            $table->boolean('dia_todo')->default(false);
            $table->boolean('emergencia')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('agendamentos_atendimentos');
    }
}
