<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterDependentesAddSexoAdmissaoConvenioObservacoes extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('dependentes', function (Blueprint $table) {
            $table->date('data_admissao');
            $table->smallInteger('sexo'); // SexoEnum
            $table->bigInteger('convenio_id')->nullable();
            $table->foreign('convenio_id')
                    ->references('id')
                    ->on('convenios');
            $table->boolean('ativo')->default(true);
            $table->text('observacoes')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('dependentes', function (Blueprint $table) {
            $table->dropColumn('data_admissao');
            $table->dropColumn('sexo');
            $table->dropColumn('convenio_id');
            $table->dropColumn('ativo');
            $table->dropColumn('observacoes');
        });
    }
}
