<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEnderecosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('enderecos', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('cep', 8);
            $table->integer('numero')->default(0);
            $table->string('logradouro', 150);
            $table->string('bairro', 50);
            $table->string('cidade', 100);
            $table->string('estado', 2);
            $table->string('observacoes', 100)->nullable();
            $table->integer('enderecavel_id');
            $table->string('enderecavel_type');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('enderecos');
    }
}
