<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateServidoresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('servidores', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('nome', 150);
            $table->string('nome_social', 150)->nullable();
            $table->string('cpf', 11);
            $table->string('rg', 11);
            $table->date('data_nascimento');
            $table->string('nome_mae', 150);
            $table->string('nome_pai', 150)->nullable();
            $table->string('naturalidade', 150);
            $table->string('observacoes', 150)->nullable();
            $table->date('data_admissao_sindicato')->nullable();
            $table->smallInteger('estado_civil'); // EstadoCivilEnum
            $table->smallInteger('sexo'); // SexoEnum
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('servidores');
    }
}
